
#include <usb.h>
#include <stdio.h>
#include <string.h>
#include <sys/time.h>

#define WRITE_SIZE 32
#define NUM_WRITES 256

enum {
  USB_VENDOR_REQUEST__CONFIGURE_BIDIRINT__SET_MASKS,
  USB_VENDOR_REQUEST__CONFIGURE_BIDIRINT__SET_STATUS,
  USB_VENDOR_REQUEST__CONFIGURE_BIDIRINT__JTAG_INIT1,
  USB_VENDOR_REQUEST__CONFIGURE_BIDIRINT__JTAG_INIT2,
  USB_VENDOR_REQUEST__CONFIGURE_BIDIRINT__JTAG_DEINIT
};

int bidirint_configure(struct usb_dev_handle* handle, unsigned char output_mask, unsigned char clock_mask, unsigned char clock_delay, unsigned char outputs_enabled) {
  int ret = usb_control_msg(handle, USB_TYPE_VENDOR | USB_RECIP_DEVICE, USB_VENDOR_REQUEST__CONFIGURE_BIDIRINT__SET_MASKS, ((int)output_mask)|(((int)clock_mask)<<8), 0, (char*)0, 0, 10);
  if( ret < 0 )
    return ret;
  return usb_control_msg(handle, USB_TYPE_VENDOR | USB_RECIP_DEVICE, USB_VENDOR_REQUEST__CONFIGURE_BIDIRINT__SET_STATUS, ((int)clock_delay)|(outputs_enabled ? 0x100 : 0), 0, (char*)0, 0, 10);
}

// Data in the buffer is written to the outputs. Each byte represents one set of states for the outputs. It is masked with the output mask.
// The input data is returned in the same data. Each byte represents one set of states of the inputs. It is masked with the inverse of the output mask.
int bidirint_exchange_data(struct usb_dev_handle* handle, unsigned char* data, int num_bytes) {
  int ret = usb_bulk_write(handle, 3, data, num_bytes, 10);
  if( ret != num_bytes )
    return ret;
  return usb_bulk_read(handle, 4, data, num_bytes, 10);
}

int main(int argc, char** argv) {
  struct usb_bus* bus;
  struct usb_device* dev;
  struct usb_dev_handle* handle;
  int i;

  usb_init();
  usb_find_busses();
  usb_find_devices();
  bus = &usb_busses[0];
  while(bus) {
    dev = &bus->devices[0];
    while(dev) {
      if( dev->descriptor.idVendor == 0x6667 && dev->descriptor.idProduct == 0x6663 ) {
        handle = usb_open(dev);
        if( handle ) {
          char data;
          while(1) {
            printf("Low half low\n");
            bidirint_configure(handle, 0x0F, 0, 0, 1);
            data = 0x00;
            if( bidirint_exchange_data(handle, &data, 1) != 1 ) {
              printf("Error!\n");
            }
            sleep(2);

            printf("Low half high\n");
            data = 0x0F;
            if( bidirint_exchange_data(handle, &data, 1) != 1 ) {
              printf("Error!\n");
            }
            sleep(2);

            printf("High half low\n");
            bidirint_configure(handle, 0xF0, 0, 0, 1);
            data = 0x00;
            if( bidirint_exchange_data(handle, &data, 1) != 1 ) {
              printf("Error!\n");
            }
            sleep(2);

            printf("High half high\n");
            data = 0xF0;
            if( bidirint_exchange_data(handle, &data, 1) != 1 ) {
              printf("Error!\n");
            }
            sleep(2);
          }
          usb_close(handle);
          return 0;
        } else {
          fprintf(stderr, "Error: Found device, but open command failed.\n");
          return -1;
        }
      }
      dev = dev->next;
    }
    bus = bus->next;
  }
  fprintf(stderr, "Error: Can't find device.\n");
  return -2;
}
